<#ibiztemplate>
TARGET=PSDEBDTABLE
</#ibiztemplate>
<#if item.getPSSysBDScheme()?? && item.getPSSysBDScheme().getBDType() == 'MONGODB' >
package ${pub.getPKGCodeName()}.mongodb;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.UUID;
import java.util.HashMap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.WriteResult;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import lombok.extern.slf4j.Slf4j;

import ${pub.getPKGCodeName()}.core.repository.${de.getCodeName()}Repository;
import ${pub.getPKGCodeName()}.core.repository.po.${de.getCodeName()};
import ${pub.getPKGCodeName()}.mongodb.po.${item.getPSSysBDTable().getCodeName()}Impl;
import ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.filter.${de.codeName}SearchContext;
import ${pub.getPKGCodeName()}.util.log.IBIZLog;


/**
 * 关系型数据实体表[${de.getCodeName()}] 对象
 */
@Slf4j
@IBIZLog
@Repository
@ConditionalOnProperty(prefix = "${de.getCodeName()?lower_case}", value="store" , havingValue = "nosql", matchIfMissing = <#if de.getStorageMode()==2>true<#else>false</#if>)
public class ${item.getPSSysBDTable().getCodeName()}RepositoryImpl implements ${de.getCodeName()}Repository{

    @Autowired
    private MongoTemplate mongoTemplate;

    public ${de.getCodeName()} createPO() {
		return new ${item.getPSSysBDTable().getCodeName()}Impl();
	}

	public ${de.getCodeName()} get(${srfjavatype(de.getKeyDEField().stdDataType)} key) {
        Query query = new Query(Criteria.where("${de.getKeyPSDEField().getCodeName()?lower_case}").is(key));
		return mongoTemplate.findOne(query, ${item.getPSSysBDTable().getCodeName()}Impl.class,"${item.getPSSysBDTable().getCodeName()?lower_case}");
	}
<#--
	public ${item.getPSSysBDTable().getCodeName()} get(${item.getPSSysBDTable().getCodeName()} po) {
		return null;
	}
-->

	public boolean create(${de.getCodeName()} po) {
        if(po.get${de.getKeyPSDEField().getCodeName()?cap_first}()==null){
			po.set${de.getKeyPSDEField().getCodeName()?cap_first}(UUID.randomUUID().toString());
		}
		mongoTemplate.save(po,"${item.getPSSysBDTable().getCodeName()?lower_case}");
		return true;
	}

	public boolean update(${de.getCodeName()} po) {
		Query query = new Query(Criteria.where("${de.getKeyPSDEField().getCodeName()?lower_case}").is(po.get${de.getKeyPSDEField().getCodeName()?cap_first}()));
        Update update = new Update();
        String str = JSON.toJSONString(po);
        JSONObject jQuery = JSON.parseObject(str);
        jQuery.forEach((key, value) -> {
            if (!key.equals("${de.getKeyPSDEField().getCodeName()?lower_case}")) {
                update.set(key, value);
            }
        });
        UpdateResult updateResult = mongoTemplate.updateFirst(query, update, ${de.getCodeName()}.class, "${item.getPSSysBDTable().getCodeName()?lower_case}");
        if(updateResult!=null && updateResult.getMatchedCount()>0)
        	return true ;
		return false;
	}

	public boolean remove(${srfjavatype(de.getKeyDEField().stdDataType)} key) {
		Query query = new Query(Criteria.where("${de.getKeyPSDEField().getCodeName()?lower_case}").is(key));
        DeleteResult deleteResult = mongoTemplate.remove(query,${de.getCodeName()}.class,"${item.getPSSysBDTable().getCodeName()?lower_case}");
        if(deleteResult != null && deleteResult.getDeletedCount()>0)
        	return true ;
        return false ;
	}

<#if de.getAllPSDEDataSets()??>
    <#list de.getAllPSDEDataSets() as dedataset>
    public Page<${de.getCodeName()}> search${dedataset.getCodeName()?cap_first}(${de.codeName}SearchContext context){
        List<${de.getCodeName()}> list = new ArrayList<${de.getCodeName()}>() ;
        Map<String, String> conditions = null ;
    	if (ObjectUtils.isEmpty(conditions)) {
            List<${item.getPSSysBDTable().getCodeName()}Impl> listImpl = mongoTemplate.findAll(${item.getPSSysBDTable().getCodeName()}Impl.class,"${item.getPSSysBDTable().getCodeName()?lower_case}");
            for (${item.getPSSysBDTable().getCodeName()}Impl ${item.getPSSysBDTable().getCodeName()?lower_case}Impl : listImpl) {
				list.add(${item.getPSSysBDTable().getCodeName()?lower_case}Impl);
			}
        } else {
            //设置分页参数
            Query query = new Query();
            query.limit(100);
            query.skip(1);
            // 往query中注入查询条件
            conditions.forEach((key, value) -> query.addCriteria(Criteria.where(key).is(value)));
            list = mongoTemplate.find(query, ${de.getCodeName()}.class,"${item.getPSSysBDTable().getCodeName()?lower_case}");
        }
        return new PageImpl<${de.getCodeName()}>(list, context.getPageable(), 10000);
    }

    </#list>
</#if>

    public ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} convert2Domain( ${de.getCodeName()} po ,${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()}();
              }
              BeanCopier copier=BeanCopier.create(po.getClass(), domain.getClass(), false);
              copier.copy(po, domain, null);
              return domain ;
    }

    public ${de.getCodeName()} convert2PO(${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} domain , ${de.getCodeName()} po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        BeanCopier copier=BeanCopier.create(domain.getClass(), po.getClass(), false);
        copier.copy(domain, po, null);
        return po ;
    }

}

</#if>
